* Purpose of file: Regression setup - defining variables and recoding missing observations
* File author: Mary-Alice Doyle
* Date last edited: 21 May 2018

set more off
ssc install outreg2 
ssc install tablecol 
ssc install tabout
ssc install winsor
do ".\Stata files\Preferred net benefit.do"


***********
* Relabelling and condensing categories
***********

* Condense education into 4 categories
gen educat2= educat if educat>4
replace educat2= 1 if educat==1 | educat==2 | educat==3 | educat==4
replace educat2 = 7 if educat==8
replace educat2 = 9 if educat==10
replace educat2=. if educat==99
label def educat2 1 "< year 12" 5 "year 12" 7 "certificate/diploma" 9 "Bachelor or higher", modify
label values educat2 educat2

* Condense employment status into 3 categories
recode empstat ( 1 2 3 =1 ) (4 5 6 7 10 = 2) (9 = 3), gen(empstatcons)
recode empstatcons 99=.
label define empstatcons 1 "Employed (1)" 2 "Working age, not employed (2)" 3 "Retired (3)", replace
label values empstatcons empstatcons

* For bank deposits variable, reduce number of categories
recode q3c (1 2 = 2), gen(deposits)
label values deposits q3c
label define q3c 2 "Under 500 (2)", modify
replace deposits = . if deposits<0


* variables are currently coded as:
* -5 for missing, -2 for don't know/prefer not to answer, and -1 for NA 
*Recode to actually missing for -5, and positive numbers for -2 and -1 so 
//that the negative numbers don't annoy the probit models
recode q8b -1=3 -2=4
label define q8b2 3 "NA (3)" 4 "Not sure (4)"
label values q8b q8b2

recode q2d -2=5
recode q2d -5=.
label define q2d 5 "no preference (5)", modify
label values q2d q2d

recode q2c1cc -5=.
recode q2c2cc -5=.
recode q2c3cc -5=.

recode q8g -5=.
recode q8e2 -5=.

recode q7c -1=0


*************
* Derived variables
*************
* indicator variable for if there is a bank branch in home postcode
gen branch = 0 if bankbranch==0
replace branch = 1 if bankbranch>0 

* ccpreferred indicates that credit cards are the respondent's (self-reported_ preferred payment method
gen ccpreferred=0
replace ccpreferred = 1 if q2d==3
replace ccpreferred=. if q2d==.

* Variable for the number of credit cards that each individual holds
gen ccnum=1 if cc1>0 & cc1<257
forvalues i = 2/10 {
	replace ccnum=ccnum+1 if cc`i'>0 & cc`i'<257
	}
replace ccnum=0 if ccnum==.
* let 3 = 3 or more
replace ccnum=3 if ccnum>3
label def ccnum 3 "3+"
label values ccnum ccnum

* in reason for interest payment, combine 'I decided to spend more...'
// with '... cash advance'
recode q7c 5=2 

* recode free text responses to reason for latest interest payment
replace q7c = 0 if q7c_oth =="I could pay it back but I made more interest by keeping my money in my high interest savings account"
replace q7c = 0 if q7c_oth =="question wasnt clear  I owe money when I get statement but paid in full..."
replace q7c = 0 if q7c_oth =="My Credit Card was used fraudulently"
replace q7c = 0 if q7c_oth =="I had a large purchase on a special reduced rate of 0.99% for 3 months"
replace q7c = 0 if q7c_oth =="didnt have outstanding interest"

label def ccinterest 0 "NA (0)" 1 "Usually/often pay interest (1)" 2 "One-off intentional (2)" 3 "Missed deadline (3)" 4 "Accidentally overspent (4)" 5 "Intentionally overspent (5)", replace
label values q7c ccinterest


** Types of cc holders
gen type = 0
* I define 5 types. Each has its own variable, and when combined into the 'type'
// variable, the respondents who fit into multiple categories are categorised based on 
// this order: points, borrowing, payment and other monetary. Everyone who doesn't fit into
// one of these categories is left on 'other'. 

gen othermonetary=0
* Other monetary motivation is respondents who would not want to borrow
// if they didn't have a credit card, and who say interest-free period,
// insrances, other benefits (concierege etc) and less costly to use overseas 
// are most important reason for choosing/having card.
replace othermonetary=1 if q8d==1  & inlist(q8f,1,3)
replace othermonetary=1 if q8d==4  & inlist(q8f,1,3)
replace othermonetary=1 if q8d==5  & inlist(q8f,1,3)
replace othermonetary=1 if q8e==6  & inlist(q8f,1,3)
replace othermonetary=1 if q8e==7  & inlist(q8f,1,3)
replace othermonetary=1 if q8e==8  & inlist(q8f,1,3)
replace othermonetary=1 if q8e==12 & inlist(q8f,1,3)
replace type = 4 if othermonetary==1

gen payer = 0
* Respondents are motivated by paying only are those who wouldn't want to borrow
// and who say they chose to have a card because it's a convenient way of paying,
// ability to shop online, widespread acceptance in AU or acceptance overseas
replace payer = 1 if q8d==12 & inlist(q8f,1,3)
replace payer = 1 if q8d==6  & inlist(q8f,1,3)
replace payer = 1 if q8d==7  & inlist(q8f,1,3)
replace payer = 1 if q8d==8  & inlist(q8f,1,3)
replace type = 3 if payer==1

gen borrower = 0 
* Respondents are motivated by borrowing if they say they would want to borrow if they
// didn't have a credit card (want to but wouldn't be able to, personal loan, or other)
// and who say they have a card because of the interest free period, because it's an 
//easy way to borrow, to smooth spending between pay periods, or chose their card based on 
// interest rate, interest free period or balance transfer deals
replace borrower = 1 if q8d==2 & inlist(q8f,2,4,5)
replace borrower = 1 if q8d==1 & inlist(q8f,2,4,5)
replace borrower = 1 if q8d==9 & inlist(q8f,2,4,5)
replace borrower = 1 if q8e==2 & inlist(q8f,2,4,5)
replace borrower = 1 if q8e==6 & inlist(q8f,2,4,5)
replace borrower = 1 if q8e==4 & inlist(q8f,2,4,5)
replace type = 2 if borrower==1

gen points=0
* Respondents are motivated by rewards points if they wouldn't want to borrow if they 
// didn't have a credit card, and say they chose their card based on bonus points
// or rewards points, or they have a card becaues of the rewards poinsts
replace points=1 if q8e==3 & inlist(q8f,1,3)
replace points=1 if q8e==5 & inlist(q8f,1,3)
replace points=1 if q8d==3 & inlist(q8f,1,3)
replace type = 1 if points==1

gen betteroff = 0
replace betteroff=1 if netbenefit1111>50
gen notworseoff = 0
replace notworseoff = 1 if netbenefit1111>-50

label def type 0 "Everyone else (0)" 1 "Points hunters (1)" 2 "Borrower (2)" 3 "Payer (3)" 4 "Other monetary motivation (4)", replace
label values type type

* recode monetary perceptions to be centred around 0: -1 loss, 0 neutral and 1 gain
recode q8g -1=. 1=0 2=-1 3=1 
label def q8g -1 "I'm worse off (-1)" 0 "Neutral (0)" 1 "I'm better off (1)" 4 "Not sure [4]", replace
label values q8g q8g

* combine variables q8a (did you sign up to your card with a special offer) with
* q8b (does that offer still apply?)
replace q8b = 4 if q8a==-2
recode q8b 0 = 2 3=0
label def q8b 0 "No offer (0)" 1 "Yes, still applies (1)" 2 "Yes, no longer applies (2)" 4 "Not sure (4)", replace
label values q8b q8b

recode q8e3 -5=.
**************************************************
* For switching section

gen considered = .
replace considered = 0 if q8c==0
replace considered = 1 if inlist(q8c,1,2,3)

gen switched = .
replace switched = 0 if inlist(q8c,0,3)
replace switched = 1 if inlist(q8c,1,2)

gen gain = .
replace gain = 1 if netbenefit1111>=50
replace gain = 0 if netbenefit1111<50
replace gain = . if netbenefit1111==.

gen loss = .
replace loss = 0 if netbenefit1111>-50
replace loss = 1 if netbenefit1111<=-50
replace loss = . if netbenefit1111==.

recode ccmaintype -5=.
recode q8h -5=.
label def q8h -1 "NA [-1]" 1 "Neutral [1]" 2 "Worse off [2]" 3 "Better off (3)" 4 "not sure [4]"
label values q8h q8h
recode ccmainreward -5=.

 * Reasons for not switching - among loss-making respondents
gen notswitching = 0 if loss==1

* loss-making respondent believes they're neutral or better off overall, 
//but knows they're worse off in monetary terms (q8g). They must value non-monetary features.
replace notswitching = 4 if inlist(q8h,1,3) & loss==1 & inlist(q8g,-1)
* respondent has paid interest and has a lower-rate card
replace notswitching = 1 if ccmaintype == 2 & loss==1 & q7b==1
* respondent actually switched cards
replace notswitching = 3 if switched==1 & loss==1
* respondent considered switching, but none of the above applies to them
replace notswitching = 5 if notswitching == 0 & considered == 1 & loss==1
label def notswitching 1 "low rate card (1)"  4 "values non-monetary featues (4)" 3 "switched cards (3)" 5 "other considered (5)" 0 "other did not consider (0)" , replace
label values notswitching notswitching 


